%% Tract-specific analysis of ALS spinal cord data
%  Regents of the University of Minnesota.
% This software is licensed under The MIT License.  
% How to cite: If you use this software for your work, please cite the following paper published in Communications Biology: 
% Pisharady, P.K., Eberly, L.E., Cheong, I. et al. Tract-specific analysis improves sensitivity of spinal cord diffusion MRI 
% to cross-sectional and longitudinal changes in amyotrophic lateral sclerosis. Commun Biol 3, 370 (2020). https://doi.org/10.1038/s42003-020-1093-z

function w=timewarp(x,N)
w = interp1(x,linspace(1,numel(x),N),'spline');
end